var currentTheme = window["env"]["companyName"];
var splashScreenStyles = `
@keyframes wave {
        20% {
          transform: translateY(-18px);
        }

        0%,
        40%,
        100% {
          transform: initial;
        }
      }

      @-webkit-keyframes wave {
        20% {
          transform: translateY(-18px);
        }

        0%,
        40%,
        100% {
          transform: initial;
        }
      }

      .splash-screen {
        z-index: 999;
        position: fixed;
        height: 100vh;
        width: 100vw;
        top: 0;
        background: #f5f8fa;
        padding: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
      }

      .splash-screen-items-wrapper {
        width: auto;
      }

      .splash-screen-text {
        font-size: 36px;
        color: #808080;
      }

      .splash-screen-dots {
        margin: 35px 0 0;
      }

      .splash-screen-dots .dot {
        position: relative;
        height: 15px;
        width: 15px;
        border-radius: 50%;
        display: inline-block;
        margin: 0 5px;
        vertical-align: middle;
        animation-duration: 1.5s;
        -webkit-animation-duration: 1.5s;
        animation-name: wave;
        -webkit-animation-name: wave;
        animation-iteration-count: infinite;
        -webkit-animation-iteration-count: infinite;
        animation-timing-function: ease-in-out;
        -webkit-animation-timing-function: ease-in-out;
      }

      .splash-screen-dots .dot-6 {
        background: #5bb8b1;
        animation-delay: -150ms;
        -webkit-animation-delay: -150ms;
      }

      .splash-screen-dots .dot-5 {
        background: #48d3f9;
        animation-delay: -300ms;
        -webkit-animation-delay: -300ms;
      }

      .splash-screen-dots .dot-4 {
        background: #31bae0;
        animation-delay: -450ms;
        -webkit-animation-delay: -450ms;
      }

      .splash-screen-dots .dot-3 {
        background: #16aaa5;
        animation-delay: -600ms;
        -webkit-animation-delay: -600ms;
      }

      .splash-screen-dots .dot-2 {
        background: #097a76;
        animation-delay: -750ms;
        -webkit-animation-delay: -750ms;
      }

      .splash-screen-dots .dot-1 {
        background: #047572;
        animation-delay: -900ms;
        -webkit-animation-delay: -900ms;
      }

      .splash-bigdar {
        background-image: url("assets/bigdar/bigDarLoad2.gif");
        background-position: center;
        background-repeat: no-repeat;
        height: 100vh;
        width: 100vw;
        background-color: #fbfbfb;
      }
        .splash-snct {
        z-index: 999;
        background:url(assets/SNCT/snct2.gif) no-repeat center center;
        background-size: contain; 
        height: 100vh;
        width: 100vw;
      }
`;
var styleSheet = document.createElement("style");
styleSheet.type = "text/css";
styleSheet.innerText = splashScreenStyles;
document.head.appendChild(styleSheet);
var splashScreenHTMLETIQUETTES = `<div class="splash-screen" id="js-splash-screen" style="display: none">
      <div class="splash-screen-items-wrapper">
        <p class="splash-screen-text">Loading</p>
        <ul class="splash-screen-dots">
          <li class="dot dot-1"></li>
          <li class="dot dot-2"></li>
          <li class="dot dot-3"></li>
          <li class="dot dot-4"></li>
          <li class="dot dot-5"></li>
          <li class="dot dot-6"></li>
        </ul>
      </div>
    </div>` ;
var splashScreenHTMLBIGDAR = `<div id="js-splash-screen-bigdar" class="splash-bigdar" style="display: none"></div>`
var splashScreenHTMLSNCT = `<div id="js-splash-screen-snct" class="splash-snct" style="display: none"></div>`

// Show the corresponding splash screen based on the current theme
if (currentTheme === "ETIQUETTES") {
  document.getElementById("Splash-Screen").innerHTML =splashScreenHTMLETIQUETTES;  
  document.getElementById("js-splash-screen").style.display = "flex";
} else if (currentTheme === "BIGDAR") {
  document.getElementById("Splash-Screen").innerHTML =splashScreenHTMLBIGDAR;
  document.getElementById("js-splash-screen-bigdar").style.display = "block";
} else if (currentTheme === "SNCT") {
  document.getElementById("Splash-Screen").innerHTML =splashScreenHTMLSNCT;
  document.getElementById("js-splash-screen-snct").style.display = "block";
}

function hideElementAfterDelay(elementId) {
  setTimeout(function () {
    document.getElementById(elementId).style.display = "none";
  }, 600);
}
